
#
#
# Generate palette
#
#


set hex_list {0 1 2 3 4 5 6 7 8 9 A B C D E F}
set color_list {}

set choice {0 3 6 9 12 15}

foreach i $choice {
	foreach j $choice {
		foreach k $choice {
			#
			# compute intensity
			#
			
			set I [expr $i*$i/0.78+$j*$j+$k*$k]
			
			# 
			# compute saturation
			#
			
			set S [expr ($i-$j)*($i-$j)+($i-$k)*($i-$k)+($j-$k)*($j-$k)]
			
			if {  ($I>100) && ($S > 120) && ($S-$I*0.7>0)} {
				set R [lindex $hex_list $i]
				set G [lindex $hex_list $j]
				set B [lindex $hex_list $k]
				lappend color_list \#$R$G$B
				}
			}}}

#set color_list [lsort -decreasing $color_list ]
set n_colors [llength $color_list]

puts $n_colors

canvas .canvas

for {set i 0} {$i<$n_colors} {incr i} {
	set x [expr ($i % 10)*25+2]
	set y [expr ($i/10)*25+2]
	.canvas create oval $x $y [expr $x+20] [expr $y+20] \
	 	-fill [lindex $color_list $i]
	}

pack .canvas -fill both -expand yes	
	
